<?php
// Fetch required classes
require_once(DIR . '/dbtech/livewall/includes/class_core.php');
require_once(DIR . '/dbtech/livewall/includes/class_cache.php');
if (intval($vbulletin->versionnumber) == 3 AND !class_exists('vB_Template'))
{
	// We need the template class
	require_once(DIR . '/dbtech/livewall/includes/class_template.php');
}

if (isset($this) AND is_object($this))
{
	// Loads the cache class
	LIVEWALL_CACHE::init($vbulletin, $this->datastore_entries);
}
else
{
	// Loads the cache class
	LIVEWALL_CACHE::init($vbulletin, $specialtemplates);
}

// Initialise forumon
LIVEWALL::init($vbulletin);

if (LIVEWALL::$permissions['canview'])
{
	$show['livewall'] = $vbulletin->options['dbtech_livewall_navbar'];
	$show['livewall_ispro'] = LIVEWALL::$isPro;
	$show['livewall_recententries'] = (LIVEWALL::$isPro AND $vbulletin->options['dbtech_livewall_recent_entries']);
	$show['livewall_favourites'] = (LIVEWALL::$isPro AND $vbulletin->options['dbtech_livewall_recent_entries'] AND $vbulletin->userinfo['userid']);
	if ($vbulletin->options['dbtech_livewall_integration'] & 1)
	{
		$show['livewall_ql'] = true;
	}
	if ($vbulletin->options['dbtech_livewall_integration'] & 2)
	{
		$show['livewall_com'] = true;
	}
}

// Show branding or not
$show['livewall_branding'] = $vbulletin->options['dbtech_livewall_branding_free'] != base64_decode('dmJ3YXJlei5uZXQ=');
$show['dbtech_livewall_producttype'] = (LIVEWALL::$isPro ? ' (Pro)' : ' (Lite)');

if (THIS_SCRIPT == 'livewall' AND $show['livewall_branding'] AND !$show['_dbtech_branding_override'])
{
	$brandingVariables = array(
		'flavour' 			=> 'Live Feed provided by ',
		'productid' 		=> 150,
		'utm_source' 		=> str_replace('www.', '', $_SERVER['HTTP_HOST']),		
		'utm_content' 		=> (LIVEWALL::$isPro ? 'Pro' : 'Lite'),
		'referrerid' 		=> $vbulletin->options['dbtech_livewall_referral'],
		'title' 			=> 'Forum Live Feed & User Wall',
		'displayversion' 	=> $vbulletin->options['dbtech_livewall_displayversion'],
		'version' 			=> LIVEWALL::$version,
		'producttype' 		=> $show['dbtech_livewall_producttype'],
		'showhivel' 		=> (!LIVEWALL::$isPro AND !$vbulletin->options['dbtech_livewall_nohivel'])
	);

	$str = $brandingVariables['flavour'] . '
		<a rel="nofollow" href="http://www.dragonbyte-tech.com/vbecommerce.php' . ($brandingVariables['productid'] ? '?productid=' . $brandingVariables['productid'] . '&do=product&' : '?') . 'utm_source=' . $brandingVariables['utm_source'] . '&utm_campaign=Footer%2BLinks&utm_medium=' . urlencode(str_replace(' ', '+', $brandingVariables['title'])) . '&utm_content=' . $brandingVariables['utm_content'] . ($brandingVariables['referrerid'] ? '&referrerid=' . $brandingVariables['referrerid'] : '') . '" target="_blank">' . $brandingVariables['title'] . ($brandingVariables['displayversion'] ? ' v' . $brandingVariables['version'] : '') . $brandingVariables['producttype'] . '</a> - 
		<a href="http://www.dragonbyte-tech.com/?utm_source=' . $brandingVariables['utm_source'] . '&utm_campaign=Footer%2BLinks&utm_medium=' . urlencode(str_replace(' ', '+', $brandingVariables['title'])) . '&utm_content=' . $brandingVariables['utm_content'] . ($brandingVariables['referrerid'] ? '&referrerid=' . $brandingVariables['referrerid'] : '') . '" target="_blank">vBulletin Mods &amp; Addons</a> Copyright &copy; ' . date('Y') . ' DragonByte Technologies Ltd.' . 
		($brandingVariables['showhivel'] ? ' Runs best on <a href="http://www.hivelocity.net/?utm_source=Iain%2BKidd&utm_medium=back%2Blink&utm_term=Dedicated%2BServer%2BSponsor&utm_campaign=Back%2BLinks%2Bfrom%2BIain%2BKidd" target="_blank">HiVelocity Hosting</a>.' : '');
	$vbulletin->options['copyrighttext'] = (trim($vbulletin->options['copyrighttext']) != '' ? $str . '<br />' . $vbulletin->options['copyrighttext'] : $str);
}

foreach ((array)LIVEWALL::$cache['contenttype'] as $contenttypeid => $contenttype)
{
	// Set active flag off for the ones that don't have existing files
	LIVEWALL::$cache['contenttype'][$contenttypeid]['enabled'] = file_exists(DIR . '/' . $contenttype['filename']);
}